CREATE OR REPLACE FUNCTION transaction_insert_policy(p_schema IN VARCHAR2,
                                                     p_object IN VARCHAR2) RETURN VARCHAR2 IS
  l_predicate VARCHAR2(4000) := NULL;
BEGIN
  -- transakcia musi byt nad uctom nastavenym v kontexte
  -- vlozit mozeme iba novu transakciu
  l_predicate := 'account_from = sys_context(''bank_context2'', ''account_no'') AND status=''NEW'' ';

  -- suma transakcie nesmie presiahnut rozdiel sumy na ucte a sucetu novych transakcii
  l_predicate := l_predicate || ' AND ( amount <= (SELECT balance
   FROM   account acc
   WHERE  acc.account_no = sys_context(''bank_context2'', ''account_no'')) -
  (SELECT nvl(SUM(amount), 0)
   FROM   TRANSACTION
   WHERE  account_from = sys_context(''bank_context2'', ''account_no'')
   AND    status = ''NEW'') )';

  -- ak je zamestnanec neobmedzujeme vysku transakcie, typ transakcie musi byt TELLER_PAY
  IF sys_context('bank_context2', 'user_type') = 'EMP' THEN
    RETURN l_predicate || ' AND trans_type = ''TELLER_PAY''';
  
    -- ak je klient, musi to byt platba typu EBANK_PAY, suma dnesnych transakcii typu EBANK_PAY  nesmie presiahnut dany limit
  ELSIF sys_context('bank_context2', 'user_type') = 'CLIENT' THEN
    RETURN l_predicate || ' AND (trans_type = ''EBANK_PAY'' AND
      amount <= (SELECT day_limit
                     FROM   account acc
                     WHERE  acc.account_no = sys_context(''bank_context2'', ''account_no'')) -
      (SELECT nvl(SUM(amount), 0)
                     FROM   TRANSACTION
                     WHERE  account_from = sys_context(''bank_context2'', ''account_no'')
                     AND    created > trunc(SYSDATE)
                     AND    status <> ''CANCELED''
                     AND    trans_type = ''EBANK_PAY''))';
  
    -- ak je terminal, musi to byt platba typu CARD_ATM alevo CARD_PAY pricom sumy dnesnych transakcii sa musia zmesit do stanoveneho limitu
  ELSIF sys_context('bank_context2', 'user_type') = 'TERMINAL' THEN
  
    RETURN l_predicate || ' AND ((trans_type = ''CARD_ATM'' AND
                  amount <= (SELECT atm_limit
                                  FROM   card
                                  WHERE  account_no = sys_context(''bank_context2'', ''account_no'')
                                  AND    valid = 1) -
                  (SELECT nvl(SUM(amount), 0)
                                  FROM   TRANSACTION
                                  WHERE  account_from = sys_context(''bank_context2'', ''account_no'')
                                  AND    created > trunc(SYSDATE)
                                  AND    status <> ''CANCELED''
                                  AND    trans_type = ''CARD_ATM'')) OR
                  (trans_type = ''CARD_PAY'' AND
                  amount <= (SELECT pay_limit
                                  FROM   card
                                  WHERE  account_no = sys_context(''bank_context2'', ''account_no'')
                                  AND    valid = 1) -
                  (SELECT nvl(SUM(amount), 0)
                                  FROM   TRANSACTION
                                  WHERE  account_from = sys_context(''bank_context2'', ''account_no'')
                                  AND    created > trunc(SYSDATE)
                                  AND    status <> ''CANCELED''
                                  AND    trans_type = ''CARD_PAY'')))';
  END IF;

  -- ak to bol iny typ pouzivatela nedovolime mu vlozenie zaznamu
  RETURN '0=1';
END transaction_insert_policy;
/

